package unificationSolver;

import java.util.Hashtable;

/**
 * @author Bill
 *
 * Rule is defined strictly, as a Horn clause, where the head is a simple sentence,
 * and the body a simpleSentence or operation (And, Or, Not). A rule with only a head
 * is an assertion (this approach of making both complete rules and assertions types of
 * rules simplifies their handling in the RuleSet class and search nodes). Assertions, are
 * leafs of the search tree.
 */
public class Rule implements PCExpression, Cloneable {

    private SimpleSentence head;
    private Goal body;

    public Rule(SimpleSentence head) {
        this(head, null);
    }

    public Rule(SimpleSentence head, Goal body) {
        this.head = head;
        this.body = body;
        
    }

    public SimpleSentence getHead(){
    		return head;
    }
    
    public Goal getBody(){
    		return body;
    }
    
    public PCExpression standardizeVariablesApart(Hashtable<Variable, Variable> newVars) 
    		throws CloneNotSupportedException{
    		SimpleSentence newHead = (SimpleSentence)getHead().standardizeVariablesApart(newVars);
    		Goal newBody = null;
    		if(getBody() != null)
    			newBody = (Goal)getBody().standardizeVariablesApart(newVars);
    		
    			Rule newRule = (Rule) this.clone();
    			newRule.head =newHead;
    			newRule.body = newBody;
    			return newRule;
    }
    

	public PCExpression replaceVariables(SubstitutionSet s) throws CloneNotSupportedException{
		SimpleSentence newHead = (SimpleSentence)getHead().replaceVariables(s);
		Goal newBody = null;
		if(getBody() != null)
			newBody = (Goal)getBody().replaceVariables(s);

		Rule newRule = (Rule) this.clone();
		newRule.head =newHead;
		newRule.body = newBody;
		return newRule;
		
	}

    public String toString() {
        if (body == null)
            return head.toString();
        return head + " :- " + body;
    }


}
